#ifndef id6F4320C0_19F9_4e67_B228_F3D17E218792
#define id6F4320C0_19F9_4e67_B228_F3D17E218792

// define the mighty NULL value. Yes, I prefer it to "0", makes it more apperant we're
// dealing with pointer values. C++ definition should be kosher, dunno about the C one.
#ifndef NULL
#ifdef __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif
#endif

// proper way to do size_t? Guess it's fine for 32bit machines.
#ifndef size_t
typedef unsigned int size_t;
#endif

// lengthof, offsetof - why aren't these part of the C standard?
// offsetof should be macro safe, lengthof could give problems. Use template func? whatever.
#ifndef offsetof
#define offsetof(s,m) (size_t)&(((s *)0)->m)
#endif
#ifndef lengthof
#define lengthof(x) (sizeof(x)/sizeof(x[0]))
#endif

// A little C++ in C. I prefer (!false) to 1, better chance of working smoothly IMO.
#ifndef __cplusplus
typedef unsigned char bool;
#define false 0
#define true (!false)
#endif

//  this __int64 definition is rather dodgy... but it compiles on both windows and linux.
#ifndef _WIN32
typedef long long __int64;
#endif

// these "new-style" typedefs aren't that common, so I'm taking the
// liberty of defining them without previous checks.
typedef unsigned char u8;
typedef signed char s8;
typedef unsigned short u16;
typedef signed short s16;
typedef unsigned int u32;
typedef signed int s32;
typedef unsigned __int64 u64;
typedef signed __int64 s64;

// uint/uchar aren't all that uncommon, so I'm #ifdef'ing their definitions
#ifndef uint
typedef unsigned int uint;
typedef signed int sint;
#endif
#ifndef uchar
typedef unsigned char uchar;
typedef signed char schar;
#endif


// some dodgy stuff to make pointer casting a bit prettier. Heavy use of these indicates
// that you're either doing very lowlevel stuff, or doing pretty bad code.
#define u8ptr(base,ofs) (u8 *) ((u8 *) base + ofs)
#define u16ptr(base,ofs) (u16 *) ((u8 *) base + ofs)
#define u32ptr(base,ofs) (u32 *) ((u8 *) base + ofs)
#define genericptr(type,base,ofs) (type *) ((u8 *) base + ofs)

// I couldn't find the proper include for the GUID struct, so... I just copied this from
// one of the *numerous* windows header files it appears in :p
#ifndef GUID_DEFINED
#define GUID_DEFINED
typedef struct _GUID
{
    unsigned long  Data1;
    unsigned short Data2;
    unsigned short Data3;
    unsigned char  Data4[8];
} GUID;
#endif /* GUID_DEFINED */

#endif // header
