/*
XCOM: UFO defense (aka   UFO: Enemy Unknown) windows version loader, by f0dder.
That's f0dder@druk.nu , http://f0dder.has it , http://f0dder.cjb.net
All rights desrever ;), 2003/04/30.
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <mmsystem.h>

#include "mytypes.h"
#include "shared.h"



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Defines and typedefs
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define	EXPORT	__declspec(dllexport)

enum	Command { CMD_OPEN, CMD_CLOSE, CMD_START, CMD_STOP };

struct CommandStruct {
	Command			cmd;
	char			*str;
};

struct Patch {
	u32		ofs;
	void	*targ;
};

#ifdef	XCOM1
#	define	HWNDVA	0x00479B60
#	define	NOPOFS	(0x0042FF2F + 5)
#elif	XCOM2
#	define	HWNDVA	0x00495EE0
#	define	NOPOFS	(0x004335DF + 5)
#else
#error Define either "XCOM1" or "XCOM2"
#endif


#define	ghwnd	(*((HWND *) HWNDVA))


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Prototypes, externs, exports, . . .
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// externs
extern "C" void pitchit(void);				// pitch-patch helper
// prototypes
static	DWORD WINAPI musicThread(LPVOID parm);
// exports
extern "C" EXPORT	void PrePatch(dllinfo_t *dllinfo);
extern "C" EXPORT	void DoPatch(void);
extern "C" EXPORT	void DoConfig(void);


BOOL	music_load(char *file);
BOOL	music_stop(void);
BOOL	music_start(void);
BOOL	music_closeall(void);



//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
// Global data
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
static	HINSTANCE			ghInst;

static	HANDLE				evtWorker;
static	CRITICAL_SECTION	csWorker;
static	CommandStruct		cmd;

//E8-patches: CALL
//E9-patches: JMP
#ifdef XCOM1
static	Patch	patchesE8[] = {
	{ 0x0042FF2F, pitchit },
	{ 0, 0 }
};

static	Patch	patchesE9[] = {
	{ 0x0045DF40, music_load },
	{ 0x0045DFC0, music_stop },
	{ 0x0045DFE0, music_start },
	{ 0x0045E000, music_closeall },
	{ 0, 0 }
};

static dllinfo_t our_dllinfo = {
	"UFO Defense.exe;xcom1.exe;ufo.exe",
	0x46054D
};
#elif XCOM2
static	Patch	patchesE8[] = {
	{ 0x004335DF, pitchit },
	{ 0, 0 }
};

static	Patch	patchesE9[] = {
	{ 0x004675F0, music_load },
	{ 0x00467670, music_stop },
	{ 0x00467690, music_start },
	{ 0x004676B0, music_closeall },
	{ 0, 0 }
};

static dllinfo_t our_dllinfo = {
	"Terror From the Deep.exe;xcom2.exe;ufo2.exe",
	0x469BED
};
#endif



void applyPatches(Patch *p, u8 opcode)
{
	DWORD	old;
	u32		imm;

	while(p->ofs != 0) {
		VirtualProtect((LPVOID) p->ofs, 5, PAGE_READWRITE, &old);

		imm = ((u32) p->targ) - (p->ofs + 5);
		*((u8 *) p->ofs) = opcode;
		*((u32 *) (p->ofs+1)) = imm;

		VirtualProtect((LPVOID) p->ofs, 5, old, &old);
		p++;
	}
}


void PrePatch(dllinfo_t *dllinfo)
{
	memcpy(dllinfo, &our_dllinfo, sizeof(our_dllinfo));
}


void DoPatch(void)
{
	DWORD var;

	// self-relative imm32 patches
	applyPatches(patchesE8, 0xE8);
	applyPatches(patchesE9, 0xE9);
	// NOP patching
	VirtualProtect((LPVOID) NOPOFS, 2, PAGE_READWRITE, &var);
	*((u16 *) NOPOFS) = 0x9090;
	VirtualProtect((LPVOID) NOPOFS, 2, var, &var);

	//MusicFix stuff
	InitializeCriticalSection(&csWorker);
	evtWorker = CreateEvent(NULL, FALSE, FALSE, NULL);
	CreateThread(NULL, 0, musicThread, NULL, 0, &var);
}


void DoConfig(void)
{
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	switch(fdwReason) {
		case DLL_PROCESS_ATTACH: {
			DisableThreadLibraryCalls(GetModuleHandle(NULL));
		}

		case DLL_PROCESS_DETACH: {
		}
	}

	return TRUE;
}



/*
DWORD WINAPI musicThread(LPVOID parm)
  This is the "worker thread" that sends out all those pesky MCI strings.
  It sits in an infinite loop, waiting for the evtWorker event to be fired.
  Then it acts on the Worker Command "packet".
*/
static DWORD WINAPI musicThread(LPVOID parm)
{
	char	buf[256];
	// signal that we're ready
	SetEvent(evtWorker);

	// enter work loop
	while(1) {
		WaitForSingleObject(evtWorker, INFINITE);
		EnterCriticalSection(&csWorker);

		switch(cmd.cmd) {
		case CMD_STOP:
			mciSendString("stop MUSIC", NULL, 0, NULL);
			break;

		case CMD_START:
			mciSendString("play MUSIC notify", NULL, 0, ghwnd);
			break;

		case CMD_CLOSE:
			mciSendString("close all", NULL, 0, NULL);
			break;

		case CMD_OPEN:
			wsprintf(buf, "open %s type sequencer alias MUSIC", cmd.str);
			mciSendString("close all", NULL, 0, NULL);
			mciSendString(buf, NULL, 0, NULL);
			mciSendString("play MUSIC from 0 notify", NULL, 0, ghwnd);
			break;
		}
		LeaveCriticalSection(&csWorker);
	}
}



/*
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Threads and wrapper functions that pass on stuff to the
MCI worker thread. Damn MCI is a pile of crap.
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
static	DWORD WINAPI threadGeneric(LPVOID parm)
{
	EnterCriticalSection(&csWorker);
	cmd.cmd = (Command) ((u32) parm);
	cmd.str = NULL;
	LeaveCriticalSection(&csWorker);
	SetEvent(evtWorker);
	return 0;
}
static DWORD WINAPI threadOpen(LPVOID parm)
{
	EnterCriticalSection(&csWorker);
	cmd.cmd = CMD_OPEN;
	cmd.str = (char *) parm;
	LeaveCriticalSection(&csWorker);
	SetEvent(evtWorker);
	return 0;
}

BOOL	music_stop(void)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadGeneric, (LPVOID) CMD_STOP, 0, &tid);
	return	TRUE;
}

BOOL	music_start(void)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadGeneric, (LPVOID) CMD_START, 0, &tid);
	return	TRUE;
}

BOOL	music_closeall(void)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadGeneric, (LPVOID) CMD_CLOSE, 0, &tid);
	return	TRUE;
}

BOOL	music_load(char *file)
{
	DWORD	tid;
	CreateThread(NULL, 0, threadOpen, (LPVOID) file, 0, &tid);
	return TRUE;
}
